<?php
// کلید دسترسی به Unsplash
define('UNSPLASH_ACCESS_KEY', '4R3E0E4_mGWfkqvVnL6EgZR89Zp1pG2YMHkLg0qKS7M');

// تابع جستجو تصاویر
function searchImages($query, $chat_id, $image_count) {
    // اضافه کردن پارامترهای بیشتر برای بهبود دقت جستجو
    $url = "https://api.unsplash.com/photos/random?query=" . urlencode($query) . 
           "&client_id=" . UNSPLASH_ACCESS_KEY . 
           "&count=" . $image_count . 
           "&orientation=landscape" .  // می‌توانید این مقدار را تغییر دهید (landscape, portrait)
           "&order_by=latest"; // مرتب‌سازی بر اساس محبوبیت

    // استفاده از cURL برای درخواست به API Unsplash
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        // خطا در درخواست cURL
        error_log("cURL Error while fetching images: " . curl_error($ch));
    }

    curl_close($ch);

    // بررسی اینکه آیا پاسخی دریافت شده است
    if ($response) {
        $images = json_decode($response, true);

        if (isset($images['errors'])) {
            // اگر خطای خاصی از سمت Unsplash برگشت داده شد
            error_log("Unsplash API returned an error: " . implode(", ", $images['errors']));
            sendMessage($chat_id, "Sorry, there was an error with the search. Please try again.");
        } elseif (is_array($images) && count($images) > 0) {
            // آماده کردن یک آرایه برای ارسال تصاویر به صورت دسته‌ای
            $media = [];
            foreach ($images as $image) {
                if (isset($image['urls']['regular'])) {
                    // اضافه کردن هر تصویر به آرایه media برای ارسال دسته‌ای
                    $media[] = ['type' => 'photo', 'media' => $image['urls']['regular']];
                } else {
                    // خطا در دریافت URL تصویر
                    error_log("No image URL found for the query: " . $query);
                    sendMessage($chat_id, "Sorry, no valid image found.");
                    return; // توقف در صورت وجود خطا
                }
            }

            // ارسال تصاویر به‌صورت دسته‌ای
            sendMediaGroup($chat_id, $media);
        } else {
            // هیچ تصویری یافت نشد
            error_log("No images found for query: " . $query);
            sendMessage($chat_id, "Sorry, no images found.");
        }
    } else {
        // خطا در دریافت اطلاعات از API
        error_log("Error fetching images from Unsplash. Response: " . $response);
        sendMessage($chat_id, "Sorry, there was an error while searching for images.");
    }
}

// تابع ارسال گروهی از تصاویر به تلگرام
function sendMediaGroup($chat_id, $media) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMediaGroup";
    $data = [
        'chat_id' => $chat_id,
        'media' => json_encode($media) // ارسال لیست تصاویر به‌صورت JSON
    ];

    // ارسال درخواست به تلگرام برای ارسال تصاویر دسته‌ای
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        // خطا در ارسال تصاویر دسته‌ای
        error_log("Error sending media group: " . curl_error($ch));
    }
    curl_close($ch);
}
?>
