<?php
// تابع جستجو با استفاده از DuckDuckGo API
function searchDuckDuckGo($query, $chat_id) {
    $url = "https://api.duckduckgo.com/?q=" . urlencode($query) . "&format=json";
    $response = file_get_contents($url);
    
    if ($response) {
        $data = json_decode($response, true);

        // چک می‌کنیم که آیا داده‌ها موجود هستند
        if (isset($data['AbstractText']) && !empty($data['AbstractText'])) {
            $message = $data['AbstractText'] . "\n\nبرای اطلاعات بیشتر، می‌توانید به لینک زیر مراجعه کنید:\n" . $data['AbstractURL'];
            sendMessage($chat_id, $message);
        } else {
            sendMessage($chat_id, "هیچ نتیجه‌ای برای جستجوی شما یافت نشد.");
        }
    } else {
        sendMessage($chat_id, "خطا در دریافت اطلاعات از DuckDuckGo.");
    }
}

// تابع ارسال پیام به تلگرام
function sendMessage($chat_id, $message) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage?chat_id=" . $chat_id . "&text=" . urlencode($message);
    file_get_contents($url);
}
?>
