<?php

// تابع برای جستجوی ویدیو در Dailymotion بر اساس لینک
function searchDailymotionVideosByLink($query, $chat_id) {
    // ساخت URL برای درخواست API Dailymotion
    $video_id = "x83iqpl";  // شناسه ویدیوی مورد نظر
    $playlist = "x6wzqs";   // شناسه پلی‌لیست (در صورت نیاز)
    $fields = "title,stream_h264_sd_url";  // اطلاعات مورد نیاز
    
    // ساختن URL درخواست از API
    $url = "https://www.dailymotion.com/json/video/{$video_id}?playlist={$playlist}&fields={$fields}";
    
    // ارسال درخواست به Dailymotion API
    $response = file_get_contents($url);
    $data = json_decode($response, true);
    
    // بررسی اینکه داده‌ها دریافت شده‌اند یا خیر
    if (isset($data['title']) && isset($data['stream_h264_sd_url'])) {
        // نمایش ویدیو
        $title = $data['title'];
        $stream_url = $data['stream_h264_sd_url'];
        
        $message = "ویدیو پیدا شد:\n\n";
        $message .= "🔹 عنوان: " . $title . "\n";
        $message .= "🔹 لینک استریم: " . $stream_url . "\n";
        
        // ارسال پیام به کاربر
        sendMessage($chat_id, $message);
    } else {
        sendMessage($chat_id, "ویدیو یافت نشد.");
    }
}

?>
