<?php

// تابع برای جستجوی ویدیو در Dailymotion
function searchDailymotionVideos($query, $chat_id, $video_count = 1) {
    // ارسال درخواست به API Dailymotion
    $api_url = "https://api.dailymotion.com/videos?search=" . urlencode($query) . "&limit=" . $video_count . "&fields=id,title,thumbnail_720_url,embed_url,description";
    
    // دریافت پاسخ از Dailymotion API
    $response = @file_get_contents($api_url);
    if ($response === false) {
        sendMessage($chat_id, "خطا در اتصال به Dailymotion. لطفا دوباره تلاش کنید.");
        return;
    }

    $videos = json_decode($response, true)['list'];

    if (!$videos) {
        sendMessage($chat_id, "متاسفانه هیچ ویدیویی پیدا نشد.");
        return;
    }

    $video_links = [];
    foreach ($videos as $video) {
        $video_links[] = [
            'title' => $video['title'],
            'url' => "https://www.dailymotion.com/video/" . $video['id'],
            'thumbnail' => $video['thumbnail_720_url'],
            'description' => $video['description'],
        ];
    }

    // ساخت پیام برای ارسال به کاربر
    $message = "ویدیوهای پیدا شده:\n";
    foreach ($video_links as $link) {
        $message .= "\n🔹 عنوان: " . $link['title'] . "\n";
        $message .= "🔹 توضیحات: " . $link['description'] . "\n";
        $message .= "🔹 لینک: " . $link['url'] . "\n";
        $message .= "🔹 تصویر بندانگشتی: " . $link['thumbnail'] . "\n";
    }

    // ارسال پیام به کاربر
    sendMessage($chat_id, $message);
}

?>
