<?php
// توکن ربات تلگرام
define('BOT_TOKEN', '8135144518:AAER9WmJPH9s8BFfLoJD0iyCdv_J67e8o9k');

// ID ادمین
define('ADMIN_ID', '5045287497');

// فایل لاگ برای خطاها
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/bot_error.log');
error_reporting(E_ALL);

// فایل ذخیره‌سازی وضعیت جستجو
define('SEARCH_STATUS_FILE', 'search_status.json');

// تابع ارسال پیام
function sendMessage($chat_id, $message, $keyboard = null) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/sendMessage?chat_id=" . $chat_id . "&text=" . urlencode($message);
    if ($keyboard) {
        $url .= "&reply_markup=" . urlencode(json_encode($keyboard));  // اضافه کردن کیبورد به درخواست
    }
    $response = file_get_contents($url);
    if ($response === false) {
        error_log("Error sending message to chat ID $chat_id: " . $message);
    }
}

// تابع ارسال منو برای انتخاب زبان
function sendLanguageMenu($chat_id) {
    $message = "لطفا زبان خود را انتخاب کنید:";
    $keyboard = [
        'keyboard' => [
            [['text' => 'فارسی'], ['text' => 'انگلیسی'], ['text' => 'روسی']],
            [['text' => 'ترکی'], ['text' => 'عربی'], ['text' => 'فرانسوی']],
            [['text' => 'اسپانیایی'], ['text' => 'همه']]  // تغییر گزینه "سایر" به "همه"
        ],
        'resize_keyboard' => true,
        'one_time_keyboard' => true
    ];
    sendMessage($chat_id, $message, $keyboard);
}

// تابع ارسال منو برای انتخاب تعداد تصاویر
function sendImageCountMenu($chat_id) {
    $message = "چند تصویر می‌خواهید جستجو کنید؟";
    $keyboard = [
        'keyboard' => [
            [['text' => '1'], ['text' => '5'], ['text' => '10']]  // تغییر دکمه‌ها به 1، 5، 10
        ],
        'resize_keyboard' => true,
        'one_time_keyboard' => true
    ];
    sendMessage($chat_id, $message, $keyboard);
}

// تابع ارسال منو برای انتخاب مرتب‌سازی تصاویر (latest یا popular)
function sendOrderByMenu($chat_id) {
    $message = "چگونه تصاویر مرتب شوند؟";
    $keyboard = [
        'keyboard' => [
            [['text' => 'latest'], ['text' => 'popular']]  // مرتب‌سازی بر اساس جدیدترین یا محبوب‌ترین
        ],
        'resize_keyboard' => true,
        'one_time_keyboard' => true
    ];
    sendMessage($chat_id, $message, $keyboard);
}

// تابع ارسال منو اصلی
function sendMainMenu($chat_id) {
    $message = "به ربات خوش آمدید! لطفا دکمه 'جستجوی تصاویر' را انتخاب کنید.";
    $keyboard = [
        'keyboard' => [
            [['text' => 'جستجوی تصاویر'], ['text' => 'جستجوی متنی']]  // اضافه کردن گزینه جستجوی متنی
        ],
        'resize_keyboard' => true,
        'one_time_keyboard' => true
    ];
    sendMessage($chat_id, $message, $keyboard);
}

// تابع بارگذاری وضعیت جستجو از فایل JSON
function loadSearchStatus() {
    if (file_exists(SEARCH_STATUS_FILE)) {
        $data = file_get_contents(SEARCH_STATUS_FILE);
        return json_decode($data, true);
    }
    return [];
}

// تابع ذخیره وضعیت جستجو به فایل JSON
function saveSearchStatus($status) {
    file_put_contents(SEARCH_STATUS_FILE, json_encode($status, JSON_PRETTY_PRINT));
}

// تابع جستجوی متنی با DuckDuckGo
function searchDuckDuckGo($query, $chat_id) {
    // URL DuckDuckGo API
    $url = "https://api.duckduckgo.com/?q=" . urlencode($query) . "&format=json&no_redirect=1";
    
    // ارسال درخواست به API
    $response = file_get_contents($url);
    $data = json_decode($response, true);

    // بررسی نتیجه جستجو
    if (isset($data['RelatedTopics']) && count($data['RelatedTopics']) > 0) {
        $message = "نتایج جستجو برای: '$query':\n";
        foreach ($data['RelatedTopics'] as $topic) {
            if (isset($topic['Text'])) {
                $message .= $topic['Text'] . "\n";
            }
        }
        sendMessage($chat_id, $message);
    } else {
        sendMessage($chat_id, "هیچ نتیجه‌ای پیدا نشد.");
    }
}

// تابع پردازش درخواست‌ها
function handleRequest($update) {
    $chat_id = $update['message']['chat']['id'];
    $message = $update['message']['text'];

    // بارگذاری وضعیت‌ها از فایل JSON
    $search_status = loadSearchStatus();

    // بررسی دستورات ورودی
    if ($message == "/start") {
        error_log("Start command received from chat ID $chat_id");
        sendMainMenu($chat_id); // نمایش منوی اصلی
    } elseif ($message == "جستجوی تصاویر") {  // نمایش منو برای انتخاب زبان بعد از جستجوی تصاویر
        sendLanguageMenu($chat_id); 
        $search_status[$chat_id] = ['status' => 'waiting_for_language'];
        saveSearchStatus($search_status);
    } elseif ($message == "جستجوی متنی") {  // شروع جستجوی متنی با DuckDuckGo
        sendMessage($chat_id, "لطفا کلمه کلیدی برای جستجو ارسال کنید.");
        $search_status[$chat_id] = ['status' => 'waiting_for_text_query'];
        saveSearchStatus($search_status);
    } elseif (isset($search_status[$chat_id]) && $search_status[$chat_id]['status'] == 'waiting_for_language') {
        // دریافت زبان انتخاب شده
        $search_status[$chat_id]['language'] = $message;
        $search_status[$chat_id]['status'] = 'waiting_for_query';
        saveSearchStatus($search_status);

        sendMessage($chat_id, "لطفا کلمه کلیدی برای جستجوی تصاویر ارسال کنید.");
    } elseif (isset($search_status[$chat_id]) && $search_status[$chat_id]['status'] == 'waiting_for_query') {
        // در حال دریافت کلمه کلیدی برای جستجو
        $search_status[$chat_id]['query'] = $message;
        $search_status[$chat_id]['status'] = 'waiting_for_order';
        saveSearchStatus($search_status);

        sendOrderByMenu($chat_id); // نمایش منوی مرتب‌سازی تصاویر
    } elseif (isset($search_status[$chat_id]) && $search_status[$chat_id]['status'] == 'waiting_for_order') {
        // دریافت نحوه مرتب‌سازی تصاویر
        $order_by = $message;
        if ($order_by !== 'latest' && $order_by !== 'popular') {
            sendMessage($chat_id, "لطفا یکی از گزینه‌های 'latest' یا 'popular' را انتخاب کنید.");
            return;
        }
        $search_status[$chat_id]['order_by'] = $order_by;
        $search_status[$chat_id]['status'] = 'waiting_for_count';
        saveSearchStatus($search_status);

        sendImageCountMenu($chat_id); // نمایش منوی تعداد تصاویر
    } elseif (isset($search_status[$chat_id]) && $search_status[$chat_id]['status'] == 'waiting_for_count') {
        // دریافت تعداد تصاویر
        $image_count = (int) $message;
        $search_status[$chat_id]['count'] = $image_count;
        $search_status[$chat_id]['status'] = 'searching_images';
        saveSearchStatus($search_status);

        // جستجو و ارسال تصاویر
        include_once('plugins/unsplash_search.php');
        searchImages($search_status[$chat_id]['query'], $chat_id, $image_count, $search_status[$chat_id]['order_by']);

        // ارسال منو جدید بعد از جستجوی تصاویر
        sendMainMenu($chat_id); // بازگشت به منوی اصلی
    } elseif (isset($search_status[$chat_id]) && $search_status[$chat_id]['status'] == 'waiting_for_text_query') {
        // جستجو متنی با DuckDuckGo
        searchDuckDuckGo($message, $chat_id);

        // بازگشت به منوی اصلی بعد از جستجو
        sendMainMenu($chat_id);
    } elseif ($message == "خروج") {
        // حذف منوها و ارسال پیام خروج
        sendMessage($chat_id, "با تشکر از استفاده شما! برای شروع مجدد /start را بزنید.");
    } else {
        // اگر دستور نامعتبر است
        error_log("Invalid command received from chat ID $chat_id: " . $message);
        sendMessage($chat_id, "ببخشید، من متوجه نشدم. لطفا دکمه 'جستجوی تصاویر' یا 'جستجوی متنی' را انتخاب کنید.");
        sendMainMenu($chat_id); // ارسال مجدد منو
    }
}

// دریافت آپدیت‌ها از تلگرام
$update = json_decode(file_get_contents('php://input'), true);

// بررسی اینکه آیا آپدیت معتبر است یا خیر
if ($update) {
    error_log("Received update: " . json_encode($update));  // لاگ دریافت آپدیت
    handleRequest($update);
} else {
    error_log("Invalid update received");
}
?>
